/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.graphy.items;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.SizeF;
import com.sybotan.android.graphy.SGraphyItem;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u00106\u001a\u000207H\u0016J(\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020 H\u0002J \u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020 H\u0002J\u0010\u0010@\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010A\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010B\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020 H\u0002J\u0018\u0010C\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u000207H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u001a\u0010)\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\f\"\u0004\b+\u0010\u000eR\u001a\u0010,\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\f\"\u0004\b.\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\f\"\u0004\b5\u0010\u000e\u00a8\u0006E"}, d2={"Lcom/sybotan/android/graphy/items/SGraphyClockItem;", "Lcom/sybotan/android/graphy/SGraphyItem;", "size", "Landroid/util/SizeF;", "parent", "(Landroid/util/SizeF;Lcom/sybotan/android/graphy/SGraphyItem;)V", "calendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "hourColor", "", "getHourColor", "()I", "setHourColor", "(I)V", "interval", "", "getInterval", "()J", "isShowScale", "", "()Z", "setShowScale", "(Z)V", "isShowSecond", "setShowSecond", "isSmooth", "setSmooth", "minuteColor", "getMinuteColor", "setMinuteColor", "padding", "", "getPadding", "()F", "setPadding", "(F)V", "pen", "Landroid/graphics/Paint;", "radius", "getRadius", "scaleColor", "getScaleColor", "setScaleColor", "secondColor", "getSecondColor", "setSecondColor", "getSize", "()Landroid/util/SizeF;", "setSize", "(Landroid/util/SizeF;)V", "textColor", "getTextColor", "setTextColor", "boundingRect", "Landroid/graphics/RectF;", "drawHour", "", "canvas", "Landroid/graphics/Canvas;", "hour", "minute", "second", "drawMinute", "drawScale", "drawScaleText", "drawSecond", "onDraw", "rect", "sybotan-android-graphy_release"})
public final class SGraphyClockItem
extends SGraphyItem {
    private boolean isShowScale;
    private int scaleColor;
    private int textColor;
    private int hourColor;
    private int minuteColor;
    private int secondColor;
    private boolean isShowSecond;
    private boolean isSmooth;
    private float padding;
    private final Paint pen;
    private final Calendar calendar;
    @NotNull
    private SizeF size;

    public final boolean isShowScale() {
        return this.isShowScale;
    }

    public final void setShowScale(boolean bl) {
        this.isShowScale = bl;
    }

    public final int getScaleColor() {
        return this.scaleColor;
    }

    public final void setScaleColor(int n) {
        this.scaleColor = n;
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int n) {
        this.textColor = n;
    }

    public final int getHourColor() {
        return this.hourColor;
    }

    public final void setHourColor(int n) {
        this.hourColor = n;
    }

    public final int getMinuteColor() {
        return this.minuteColor;
    }

    public final void setMinuteColor(int n) {
        this.minuteColor = n;
    }

    public final int getSecondColor() {
        return this.secondColor;
    }

    public final void setSecondColor(int n) {
        this.secondColor = n;
    }

    public final boolean isShowSecond() {
        return this.isShowSecond;
    }

    public final void setShowSecond(boolean bl) {
        this.isShowSecond = bl;
    }

    public final boolean isSmooth() {
        return this.isSmooth;
    }

    public final void setSmooth(boolean bl) {
        this.isSmooth = bl;
    }

    public final float getPadding() {
        return this.padding;
    }

    public final void setPadding(float f) {
        this.padding = f;
    }

    private final float getRadius() {
        float f = this.size.getWidth();
        float f2 = this.size.getHeight();
        boolean bl = false;
        return Math.min(f, f2) / 2.0f - this.padding;
    }

    private final long getInterval() {
        return this.isShowSecond && this.isSmooth ? 40L : 1000L;
    }

    @Override
    @NotNull
    public RectF boundingRect() {
        return new RectF(0.0f, 0.0f, this.size.getWidth(), this.size.getHeight());
    }

    @Override
    public void onDraw(@NotNull Canvas canvas, @NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        canvas.translate(this.size.getWidth() / 2.0f, this.size.getHeight() / 2.0f);
        if (this.isShowScale) {
            this.drawScale(canvas);
            this.drawScaleText(canvas);
        }
        Calendar calendar = this.calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"calendar");
        calendar.setTime(new Date());
        int hour = this.calendar.get(10);
        int minute = this.calendar.get(12);
        float second = this.calendar.get(13);
        if (this.isSmooth) {
            second += (float)this.calendar.get(14) / 1000.0f;
        }
        this.drawHour(canvas, hour, minute, second);
        this.drawMinute(canvas, minute, second);
        if (this.isShowSecond) {
            this.drawSecond(canvas, second);
        }
        this.postInvalidateDelayed(this.getInterval());
    }

    /*
     * WARNING - void declaration
     */
    private final void drawScale(Canvas canvas) {
        float f = this.getRadius() / 10.0f;
        float f2 = 2.0f;
        boolean bl = false;
        float scaleLength = Math.max(f, f2);
        float scaleLength1 = scaleLength * 1.2f;
        float f3 = this.getRadius() / 100.0f;
        float f4 = 2.0f;
        int n = 0;
        float strokeWidth = Math.max(f3, f4);
        float strokeWidth1 = strokeWidth * 2.0f;
        canvas.save();
        this.pen.setColor(this.scaleColor);
        int n2 = 1;
        n = 12;
        while (n2 <= n) {
            void i;
            this.pen.setStrokeWidth(strokeWidth1);
            canvas.drawLine(0.0f, -this.getRadius(), 0.0f, -this.getRadius() + scaleLength1, this.pen);
            if (this.getRadius() >= (float)50) {
                canvas.rotate(6.0f);
                int n3 = 1;
                int n4 = 4;
                while (n3 <= n4) {
                    void j;
                    this.pen.setStrokeWidth(strokeWidth);
                    canvas.drawLine(0.0f, -this.getRadius(), 0.0f, -this.getRadius() + scaleLength, this.pen);
                    canvas.rotate(6.0f);
                    ++j;
                }
            } else {
                canvas.rotate(30.0f);
            }
            ++i;
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawScaleText(Canvas canvas) {
        float fontSize = this.getRadius() / 5.0f;
        if (fontSize < (float)20) {
            return;
        }
        this.pen.setColor(this.textColor);
        this.pen.setTextAlign(Paint.Align.CENTER);
        this.pen.setTextSize(fontSize);
        float offset = (this.pen.getFontMetrics().bottom + this.pen.getFontMetrics().top) / (float)2;
        float r = this.getRadius() - this.getRadius() / 3.8f;
        int n = 1;
        int n2 = 12;
        while (n <= n2) {
            void i;
            double d = (double)i * Math.PI / (double)6.0f - 1.5707963267948966;
            double d2 = r;
            boolean bl = false;
            double d3 = Math.cos(d);
            float x1 = (float)(d2 * d3);
            double d4 = (double)i * Math.PI / (double)6.0f - 1.5707963267948966;
            d2 = r;
            boolean bl2 = false;
            d3 = Math.sin(d4);
            float y1 = (float)(d2 * d3 - (double)offset);
            canvas.drawText(String.valueOf((int)i), x1, y1, this.pen);
            ++i;
        }
    }

    private final void drawHour(Canvas canvas, int hour, int minute, float second) {
        canvas.save();
        this.pen.setStrokeCap(Paint.Cap.ROUND);
        float f = this.getRadius() / 30.0f;
        float f2 = 4.0f;
        Paint paint = this.pen;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        paint.setStrokeWidth(f3);
        this.pen.setColor(this.hourColor);
        canvas.rotate((float)hour * 30.0f + (float)minute * 30.0f / (float)60 + second * 30.0f / (float)60 / (float)60);
        canvas.drawLine(0.0f, this.getRadius() / 10.0f, 0.0f, -this.getRadius() / 2.5f, this.pen);
        canvas.drawCircle(0.0f, 0.0f, this.getRadius() / 30.0f, this.pen);
        canvas.restore();
    }

    private final void drawMinute(Canvas canvas, int minute, float second) {
        canvas.save();
        this.pen.setStrokeCap(Paint.Cap.ROUND);
        float f = this.getRadius() / 40.0f;
        float f2 = 4.0f;
        Paint paint = this.pen;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        paint.setStrokeWidth(f3);
        this.pen.setColor(this.minuteColor);
        canvas.rotate((float)minute * 6.0f + second * 6.0f / 60.0f);
        canvas.drawLine(0.0f, this.getRadius() / 10.0f, 0.0f, -this.getRadius() * 3.0f / 5.0f, this.pen);
        this.pen.setColor(-256);
        canvas.drawCircle(0.0f, 0.0f, this.getRadius() / 100.0f, this.pen);
        canvas.restore();
    }

    private final void drawSecond(Canvas canvas, float second) {
        canvas.save();
        this.pen.setStrokeCap(Paint.Cap.ROUND);
        float f = this.getRadius() / 100.0f;
        float f2 = 3.0f;
        Paint paint = this.pen;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        paint.setStrokeWidth(f3);
        this.pen.setColor(this.secondColor);
        canvas.rotate(second * 6.0f);
        canvas.drawLine(0.0f, this.getRadius() / 5.0f, 0.0f, -this.getRadius() + this.getRadius() / 10.0f, this.pen);
        canvas.drawCircle(0.0f, 0.0f, this.getRadius() / 30.0f, this.pen);
        canvas.drawCircle(0.0f, -this.getRadius() + this.getRadius() / 5.0f, this.getRadius() / 60.0f, this.pen);
        this.pen.setColor(-256);
        canvas.drawCircle(0.0f, 0.0f, this.getRadius() / 100.0f, this.pen);
        canvas.restore();
    }

    @NotNull
    public final SizeF getSize() {
        return this.size;
    }

    public final void setSize(@NotNull SizeF sizeF) {
        Intrinsics.checkParameterIsNotNull((Object)sizeF, (String)"<set-?>");
        this.size = sizeF;
    }

    public SGraphyClockItem(@NotNull SizeF size, @Nullable SGraphyItem parent) {
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        super(parent);
        this.size = size;
        this.isShowScale = true;
        this.scaleColor = -16777216;
        this.textColor = -16777216;
        this.hourColor = -16777216;
        this.minuteColor = -16777216;
        this.secondColor = -65536;
        this.isShowSecond = true;
        this.isSmooth = true;
        this.padding = 100.0f;
        this.pen = new Paint();
        this.calendar = Calendar.getInstance();
    }

    public /* synthetic */ SGraphyClockItem(SizeF sizeF, SGraphyItem sGraphyItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            sGraphyItem = null;
        }
        this(sizeF, sGraphyItem);
    }
}

