/*
 * Decompiled with CFR 0.152.
 */
package com.dothantech.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.dothantech.common.l;
import com.dothantech.common.u;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

@SuppressLint(value={"DefaultLocale"})
public abstract class DzWindow {
    public static final u Log = u.a("DzWindow");

    public static Object getWindowManager() {
        Object object = null;
        try {
            object = Class.forName("android.view.WindowManagerGlobal");
            Log.c("DzWindow.getWindowManager() with android.view.WindowManagerGlobal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.c("DzWindow.getWindowManager() without android.view.WindowManagerGlobal");
        }
        if (object != null) {
            if ((object = l.a(object, "getInstance", null)) == null) {
                Log.f("DzWindow.getWindowManager() failed for getInstance failed.");
                return null;
            }
            try {
                object = ((Method)object).invoke(null, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.f("DzWindow.getWindowManager() failed for getInstance failed for IllegalArgumentException.");
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.f("DzWindow.getWindowManager() failed for getInstance failed for IllegalAccessException.");
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.f("DzWindow.getWindowManager() failed for getInstance failed for InvocationTargetException.");
                return null;
            }
        }
        try {
            object = Class.forName("android.view.WindowManagerImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.f("DzWindow.getWindowManager() failed for android.view.WindowManagerImpl class not found.");
            return null;
        }
        object = l.a(object, "getDefault", null);
        if (object == null) {
            Log.f("DzWindow.getWindowManager() failed for getDefault failed.");
            return null;
        }
        try {
            object = ((Method)object).invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.f("DzWindow.getWindowManager() failed for getDefault failed for IllegalArgumentException.");
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.f("DzWindow.getWindowManager() failed for getDefault failed for IllegalAccessException.");
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.f("DzWindow.getWindowManager() failed for getDefault failed for InvocationTargetException.");
            return null;
        }
        if (object == null) {
            Log.f("DzWindow.getWindowManager() failed for return value is null.");
        }
        return object;
    }

    public static ArrayList<ViewInfo> getViewInfos() {
        ArrayList<ViewInfo> arrayList;
        block11: {
            Object object2 = DzWindow.getWindowManager();
            if (object2 == null) {
                return null;
            }
            arrayList = new ArrayList<ViewInfo>();
            try {
                Object[] objectArray;
                Object classCastException = l.b(object2, "mRoots");
                if (classCastException == null) break block11;
                if (classCastException instanceof Iterable) {
                    Iterable throwable = (Iterable)classCastException;
                    for (Object t2 : throwable) {
                        try {
                            ViewInfo viewInfo = new ViewInfo(t2);
                            arrayList.add(viewInfo);
                        }
                        catch (Throwable throwable2) {
                            Log.c("DzWindow.getViewInfos() new ViewInfo(%s) failed.", t2);
                        }
                    }
                    break block11;
                }
                Object[] objectArray2 = objectArray = (Object[])classCastException;
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object object = objectArray2[n3];
                    try {
                        ViewInfo viewInfo = new ViewInfo(object);
                        arrayList.add(viewInfo);
                    }
                    catch (Throwable throwable) {
                        Log.c("DzWindow.getViewInfos() new ViewInfo(%s) failed.", object);
                    }
                    ++n3;
                }
            }
            catch (ClassCastException classCastException) {
                Log.d("DzWindow.getViewInfos() failed for %s", classCastException.toString());
                return null;
            }
            catch (Throwable throwable) {
                Log.d("DzWindow.getViewInfos() failed for %s", throwable.toString());
                return null;
            }
        }
        return arrayList;
    }

    public static int getViewCount() {
        return DzWindow.getViewCount(true);
    }

    public static int getViewCount(boolean bl) {
        ArrayList<ViewInfo> arrayList2 = DzWindow.getViewInfos();
        if (arrayList2 == null) {
            return 0;
        }
        int n2 = 0;
        for (ViewInfo viewInfo : arrayList2) {
            if (bl && viewInfo.mActivity == null) continue;
            ++n2;
        }
        return n2;
    }

    public static ArrayList<ViewInfo> getViewInfos(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<ViewInfo> arrayList3 = DzWindow.getViewInfos();
        if (arrayList3 == null) {
            return null;
        }
        ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>();
        for (ViewInfo viewInfo : arrayList3) {
            if (viewInfo.mActivity == null || viewInfo.mActivity.getClass() != clazz) continue;
            arrayList.add(viewInfo);
        }
        return arrayList;
    }

    public static ArrayList<ViewInfo> getViewInfos(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.indexOf(46) >= 0) {
            try {
                return DzWindow.getViewInfos(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.d("DzWindow.getViewInfos(%s) failed for %s", string, classNotFoundException.toString());
            }
        } else {
            ArrayList<ViewInfo> arrayList3 = DzWindow.getViewInfos();
            if (arrayList3 == null) {
                return null;
            }
            ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>();
            for (ViewInfo viewInfo : arrayList3) {
                if (viewInfo.mActivity == null || viewInfo.mActivity.getClass().getSimpleName() != string) continue;
                arrayList.add(viewInfo);
            }
            return arrayList;
        }
        return null;
    }

    public static ArrayList<ViewInfo> getViewInfosByTitle(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return DzWindow.getViewInfos();
        }
        ArrayList<ViewInfo> arrayList3 = DzWindow.getViewInfos();
        if (arrayList3 == null) {
            return null;
        }
        ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>();
        for (ViewInfo viewInfo : arrayList3) {
            if (viewInfo.mActivity == null || viewInfo.mTitle == null || !string.equalsIgnoreCase(viewInfo.mTitle.toString())) continue;
            arrayList.add(viewInfo);
        }
        return arrayList;
    }

    public static ViewInfo getActiveViewInfo() {
        ArrayList<ViewInfo> arrayList = DzWindow.getViewInfos();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            ViewInfo viewInfo = arrayList.get(n2);
            if (viewInfo.mActivity != null) {
                return viewInfo;
            }
            --n2;
        }
        return null;
    }

    public static Activity getActiveActivity() {
        ViewInfo viewInfo = DzWindow.getActiveViewInfo();
        if (viewInfo != null) {
            return viewInfo.mActivity;
        }
        return null;
    }

    public static ViewInfo getMainViewInfo() {
        ArrayList<ViewInfo> arrayList = DzWindow.getViewInfos();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ViewInfo viewInfo = arrayList.get(n2);
            if (viewInfo.mActivity != null) {
                return viewInfo;
            }
            ++n2;
        }
        return null;
    }

    public static Activity getMainActivity() {
        ViewInfo viewInfo = DzWindow.getMainViewInfo();
        if (viewInfo != null) {
            return viewInfo.mActivity;
        }
        return null;
    }

    public static int backToMainActivity() {
        Object object;
        ArrayList<ViewInfo> arrayList = DzWindow.getViewInfos();
        if (arrayList == null || arrayList.size() <= 0) {
            return 0;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object = arrayList.get(n4);
            if (((ViewInfo)object).mActivity != null) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        if (n2 < 0) {
            return 0;
        }
        n4 = arrayList.size() - 1;
        while (n4 > n2) {
            object = arrayList.get(n4);
            if (((ViewInfo)object).mActivity != null) {
                try {
                    ((ViewInfo)object).mActivity.finish();
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
                ++n3;
            }
            --n4;
        }
        return n3;
    }

    public static Activity getActivity(Class<?> serializable) {
        if ((serializable = DzWindow.getViewInfos(serializable)) == null || ((ArrayList)serializable).size() <= 0) {
            return null;
        }
        return ((ViewInfo)((ArrayList)serializable).get((int)(((ArrayList)serializable).size() - 1))).mActivity;
    }

    public static Activity getActivity(String object) {
        if ((object = DzWindow.getViewInfos((String)object)) == null || ((ArrayList)object).size() <= 0) {
            return null;
        }
        return ((ViewInfo)((ArrayList)object).get((int)(((ArrayList)object).size() - 1))).mActivity;
    }

    public static Activity getActivityByTitle(String object) {
        if ((object = DzWindow.getViewInfosByTitle((String)object)) == null || ((ArrayList)object).size() <= 0) {
            return null;
        }
        return ((ViewInfo)((ArrayList)object).get((int)(((ArrayList)object).size() - 1))).mActivity;
    }

    public static class ViewInfo {
        public final CharSequence mTitle;
        public final boolean mAppVisible;
        public final Context mContext;
        public final Activity mActivity;
        public final Object mRoot;
        public final View mView;

        public ViewInfo(Object object) {
            this.mRoot = object;
            this.mAppVisible = l.a(this.mRoot, "mAppVisible");
            this.mView = (View)l.b(this.mRoot, "mView");
            object = null;
            if (this.mView instanceof ViewGroup) {
                object = ((ViewGroup)this.mView).getChildAt(0);
            }
            object = object == null ? this.mView : object;
            this.mContext = object.getContext();
            object = this.mContext;
            this.mActivity = object instanceof Activity ? (Activity)object : null;
            this.mTitle = this.mActivity == null ? null : this.mActivity.getTitle();
        }

        public int getTaskId() {
            if (this.mActivity == null) {
                return 0;
            }
            return this.mActivity.getTaskId();
        }

        public String toString() {
            return String.format("ViewInfo.%s [TaskId=%d, mTitle=%s, mAppVisible=%s]", this.mContext == null ? null : this.mContext.getClass().getSimpleName(), this.getTaskId(), this.mTitle, this.mAppVisible);
        }
    }
}

