/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.base.utils;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sybotan/android/base/utils/SKeyboardUtil;", "", "()V", "dismissSoftKeyboard", "", "activity", "Landroid/app/Activity;", "sybotan-android-base_release"})
public final class SKeyboardUtil {
    public static final SKeyboardUtil INSTANCE;

    public final boolean dismissSoftKeyboard(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        try {
            boolean bl;
            Object object = activity.getSystemService("input_method");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager inputMethodManage = (InputMethodManager)object;
            if (activity.getCurrentFocus() == null) {
                Window window = activity.getWindow();
                Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
                View view = window.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"activity.window.decorView");
                bl = inputMethodManage.hideSoftInputFromWindow(view.getWindowToken(), 0);
            } else {
                View view = activity.getCurrentFocus();
                if (view == null) {
                    Intrinsics.throwNpe();
                }
                bl = inputMethodManage.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private SKeyboardUtil() {
    }

    static {
        SKeyboardUtil sKeyboardUtil;
        INSTANCE = sKeyboardUtil = new SKeyboardUtil();
    }
}

