/*
 * Decompiled with CFR 0.152.
 */
package com.sybotan.android.base.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.webkit.JavascriptInterface;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J&\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/sybotan/android/base/utils/SQrCodeUtil;", "", "()V", "bgColor", "", "getBgColor", "()I", "setBgColor", "(I)V", "pixelColor", "getPixelColor", "setPixelColor", "addLogo", "Landroid/graphics/Bitmap;", "src", "logo", "createQrCode", "contents", "", "size", "decodeQrCode", "bitmap", "binaryBitmap", "Lcom/google/zxing/BinaryBitmap;", "sybotan-android-base_release"})
public final class SQrCodeUtil {
    private static int bgColor;
    private static int pixelColor;
    public static final SQrCodeUtil INSTANCE;

    public final int getBgColor() {
        return bgColor;
    }

    public final void setBgColor(int n) {
        bgColor = n;
    }

    public final int getPixelColor() {
        return pixelColor;
    }

    public final void setPixelColor(int n) {
        pixelColor = n;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @Nullable
    public final Bitmap createQrCode(@NotNull String contents, int size, @Nullable Bitmap logo) {
        Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
        try {
            Hashtable hints = new Hashtable();
            ((Map)hints).put(EncodeHintType.CHARACTER_SET, "utf-8");
            ((Map)hints).put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            BitMatrix matrix = new QRCodeWriter().encode(contents, BarcodeFormat.QR_CODE, size, size, (Map)hints);
            Bitmap image = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void y;
                int n3 = 0;
                int n4 = size;
                while (n3 < n4) {
                    void x;
                    if (matrix.get((int)x, (int)y)) {
                        image.setPixel((int)x, (int)y, pixelColor);
                    } else {
                        image.setPixel((int)x, (int)y, bgColor);
                    }
                    ++x;
                }
                ++y;
            }
            if (logo != null) {
                Bitmap bitmap = image;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"image");
                image = this.addLogo(bitmap, logo);
            }
            return image;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static /* synthetic */ Bitmap createQrCode$default(SQrCodeUtil sQrCodeUtil, String string, int n, Bitmap bitmap, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bitmap = null;
        }
        return sQrCodeUtil.createQrCode(string, n, bitmap);
    }

    @Nullable
    public final String decodeQrCode(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        RGBLuminanceSource luminanceSource = new RGBLuminanceSource(width, height, pixels);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)luminanceSource));
        return this.decodeQrCode(binaryBitmap);
    }

    @Nullable
    public final String decodeQrCode(@NotNull BinaryBitmap binaryBitmap) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)binaryBitmap, (String)"binaryBitmap");
        try {
            Result result;
            HashMap hints = new HashMap();
            ((Map)hints).put(DecodeHintType.CHARACTER_SET, "utf-8");
            ((Map)hints).put(DecodeHintType.TRY_HARDER, true);
            ((Map)hints).put(DecodeHintType.POSSIBLE_FORMATS, BarcodeFormat.QR_CODE);
            Result result2 = result = new QRCodeReader().decode(binaryBitmap, (Map)hints);
            Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"result");
            string = result2.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    private final Bitmap addLogo(Bitmap src, Bitmap logo) {
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        Bitmap image = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawBitmap(src, 0.0f, 0.0f, null);
        canvas.drawBitmap(logo, new Rect(0, 0, srcWidth, srcHeight), new RectF((float)(srcWidth * 2) / 5.0f, (float)(srcHeight * 2) / 5.0f, (float)(srcWidth * 3) / 5.0f, (float)(srcHeight * 3) / 5.0f), null);
        Bitmap bitmap = image;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"image");
        return bitmap;
    }

    private SQrCodeUtil() {
    }

    static {
        SQrCodeUtil sQrCodeUtil;
        INSTANCE = sQrCodeUtil = new SQrCodeUtil();
        bgColor = (int)0xFFFFFFFFL;
        pixelColor = (int)0xFF000000L;
    }
}

