/*
 * Decompiled with CFR 0.152.
 */
package com.dothantech.printer;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import com.dothantech.common.g;
import com.dothantech.common.t;
import com.dothantech.common.w;
import com.dothantech.data.c;
import com.dothantech.printer.IDzPrinter;
import java.util.Arrays;

@SuppressLint(value={"DefaultLocale"})
public interface IDzPrinter2
extends IDzPrinter {
    public static final String DEFAULT_BOND_PASSWORD = "0000";

    public boolean bond(String var1);

    public boolean bond(String var1, String var2);

    public boolean onNfcDiscovery(Intent var1);

    public PrinterParam getPrinterParam();

    public boolean refreshPrinterParam();

    public boolean setPrinterParam(Bundle var1);

    public boolean setPrinterParam(Bundle var1, IDzPrinter.IActionCallback var2);

    public boolean sendDataPackage(c.a var1);

    public boolean sendDataPackage(c.a var1, IDzPrinter.IActionCallback var2);

    public boolean startDeviceDiscovery(IDzPrinter.AddressType var1);

    public void cancel(int var1);

    public static abstract class DeviceAddrTypeConverter {
        public static IDzPrinter.AddressType type(byte by) {
            return DeviceAddrTypeConverter.type(by & 0xFF);
        }

        public static IDzPrinter.AddressType type(int n2) {
            if (n2 >= 240 && n2 < 248) {
                return IDzPrinter.AddressType.WiFi;
            }
            if ((n2 & 4) == 4) {
                return IDzPrinter.AddressType.BLE;
            }
            return IDzPrinter.AddressType.SPP;
        }

        public static int type(IDzPrinter.AddressType addressType) {
            switch (addressType) {
                case BLE: {
                    return 20;
                }
                case WiFi: {
                    return 240;
                }
            }
            return 16;
        }
    }

    public static interface IDzPrinterCallback2
    extends IDzPrinter.IDzPrinterCallback {
        public void onBondProgress(IDzPrinter.PrinterAddress var1, IDzPrinter.GeneralProgress var2);

        public void onSetParamProgress(IDzPrinter.PrinterAddress var1, IDzPrinter.GeneralProgress var2);

        public void onSendDataProgress(c.a var1, IDzPrinter.GeneralProgress var2);

        public void onPrinterParamChanged(IDzPrinter.PrinterAddress var1, PrinterParam var2, PrinterParam var3);

        public void onDeviceDiscovery(IDzPrinter.GeneralProgress var1, Object var2);
    }

    public static class PrinterParam
    implements Cloneable {
        public int deviceType;
        public String deviceName;
        public String deviceVersion;
        public String softwareVersion;
        public String deviceAddress;
        public int deviceAddrType;
        public int printerDPI;
        public int printerWidth;
        public int printDensity;
        public int printSpeed;
        public int gapType;
        public int gapLength;
        public int motorMode;
        public int autoPowerOffMins;
        public int language;
        public int[] supportedGapTypes;
        public int[] supportedMotorModes;
        public int[] supportedLanguages;
        public String seriesName;
        public String devIntName;
        public int peripheralFlags;
        public int hardwareFlags;
        public int softwareFlags;

        public PrinterParam(int n2, String string, String string2, String string3, String string4, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray, int[] nArray2, int[] nArray3, String string5, String string6, int n13, int n14, int n15) {
            this.deviceType = n2;
            this.deviceName = string;
            this.deviceVersion = string2;
            this.softwareVersion = string3;
            this.deviceAddress = string4;
            this.deviceAddrType = n3;
            this.printerDPI = n4;
            this.printerWidth = n5;
            this.printDensity = n6;
            this.printSpeed = n7;
            this.gapType = n8;
            this.gapLength = n9;
            this.motorMode = n10;
            this.autoPowerOffMins = n11;
            this.language = n12;
            this.setSupportedGapTypes(nArray);
            this.setSupportedMotorModes(nArray2);
            this.setSupportedLanguages(nArray3);
            this.seriesName = string5;
            this.devIntName = string6;
            this.peripheralFlags = n13;
            this.hardwareFlags = n14;
            this.softwareFlags = n15;
        }

        public void setSupportedGapTypes(int[] nArray) {
            if (nArray != null && nArray.length > 0) {
                this.supportedGapTypes = new int[nArray.length];
                System.arraycopy(nArray, 0, this.supportedGapTypes, 0, nArray.length);
                return;
            }
            this.supportedGapTypes = new int[0];
        }

        public void setSupportedMotorModes(int[] nArray) {
            if (nArray != null && nArray.length > 0) {
                this.supportedMotorModes = new int[nArray.length];
                System.arraycopy(nArray, 0, this.supportedMotorModes, 0, nArray.length);
                return;
            }
            this.supportedMotorModes = new int[0];
        }

        public void setSupportedLanguages(int[] nArray) {
            if (nArray != null && nArray.length > 0) {
                this.supportedLanguages = new int[nArray.length];
                System.arraycopy(nArray, 0, this.supportedLanguages, 0, nArray.length);
                return;
            }
            this.supportedLanguages = new int[0];
        }

        public IDzPrinter.AddressType getAddressType() {
            return DeviceAddrTypeConverter.type(this.deviceAddrType);
        }

        public String toString() {
            return "PrinterParam [deviceType=" + this.deviceType + ", deviceName=" + this.deviceName + ", deviceVersion=" + this.deviceVersion + ", softwareVersion=" + this.softwareVersion + ", deviceAddress=" + this.deviceAddress + ", deviceAddrType=" + t.a(this.deviceAddrType, true, g.a.c) + ", printerDPI=" + this.printerDPI + ", printerWidth=" + this.printerWidth + ", printDensity=" + this.printDensity + ", printSpeed=" + this.printSpeed + ", gapType=" + this.gapType + ", gapLength=" + this.gapLength + ", motorMode=" + this.motorMode + ", autoPowerOffMins=" + this.autoPowerOffMins + ", language=" + this.language + ", supportedGapTypes=" + Arrays.toString(this.supportedGapTypes) + ", supportedMotorModes=" + Arrays.toString(this.supportedMotorModes) + ", supportedLanguages=" + Arrays.toString(this.supportedLanguages) + ", seriesName = " + this.seriesName + ", devIntName = " + this.devIntName + ", peripheralFlags = " + t.a(this.peripheralFlags) + ", hardwareFlags = " + t.a(this.hardwareFlags) + ", softwareFlags = " + t.a(this.softwareFlags) + "]";
        }

        public boolean equals(Object object) {
            block47: {
                block46: {
                    block45: {
                        block44: {
                            block43: {
                                block42: {
                                    block41: {
                                        block40: {
                                            block39: {
                                                block38: {
                                                    block37: {
                                                        block36: {
                                                            block35: {
                                                                block34: {
                                                                    block33: {
                                                                        block32: {
                                                                            block31: {
                                                                                block30: {
                                                                                    block29: {
                                                                                        block28: {
                                                                                            block27: {
                                                                                                block26: {
                                                                                                    if (this == object) {
                                                                                                        return true;
                                                                                                    }
                                                                                                    if (object == null) {
                                                                                                        return false;
                                                                                                    }
                                                                                                    try {
                                                                                                        object = (PrinterParam)object;
                                                                                                        if (this.deviceType == ((PrinterParam)object).deviceType) break block26;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        object = exception;
                                                                                                        exception.printStackTrace();
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (w.a(this.deviceName, ((PrinterParam)object).deviceName)) break block27;
                                                                                                return false;
                                                                                            }
                                                                                            if (w.a(this.deviceVersion, ((PrinterParam)object).deviceVersion)) break block28;
                                                                                            return false;
                                                                                        }
                                                                                        if (w.a(this.deviceAddress, ((PrinterParam)object).deviceAddress)) break block29;
                                                                                        return false;
                                                                                    }
                                                                                    if (this.deviceAddrType == ((PrinterParam)object).deviceAddrType) break block30;
                                                                                    return false;
                                                                                }
                                                                                if (this.printerDPI == ((PrinterParam)object).printerDPI) break block31;
                                                                                return false;
                                                                            }
                                                                            if (this.printerWidth == ((PrinterParam)object).printerWidth) break block32;
                                                                            return false;
                                                                        }
                                                                        if (this.gapLength == ((PrinterParam)object).gapLength) break block33;
                                                                        return false;
                                                                    }
                                                                    if (this.gapType == ((PrinterParam)object).gapType) break block34;
                                                                    return false;
                                                                }
                                                                if (this.language == ((PrinterParam)object).language) break block35;
                                                                return false;
                                                            }
                                                            if (this.motorMode == ((PrinterParam)object).motorMode) break block36;
                                                            return false;
                                                        }
                                                        if (this.printDensity == ((PrinterParam)object).printDensity) break block37;
                                                        return false;
                                                    }
                                                    if (this.printSpeed == ((PrinterParam)object).printSpeed) break block38;
                                                    return false;
                                                }
                                                if (this.autoPowerOffMins == ((PrinterParam)object).autoPowerOffMins) break block39;
                                                return false;
                                            }
                                            if (w.a(this.softwareVersion, ((PrinterParam)object).softwareVersion)) break block40;
                                            return false;
                                        }
                                        if (Arrays.equals(this.supportedGapTypes, ((PrinterParam)object).supportedGapTypes)) break block41;
                                        return false;
                                    }
                                    if (Arrays.equals(this.supportedLanguages, ((PrinterParam)object).supportedLanguages)) break block42;
                                    return false;
                                }
                                if (Arrays.equals(this.supportedMotorModes, ((PrinterParam)object).supportedMotorModes)) break block43;
                                return false;
                            }
                            if (w.a(this.seriesName, ((PrinterParam)object).seriesName)) break block44;
                            return false;
                        }
                        if (w.a(this.devIntName, ((PrinterParam)object).devIntName)) break block45;
                        return false;
                    }
                    if (this.peripheralFlags == ((PrinterParam)object).peripheralFlags) break block46;
                    return false;
                }
                if (this.hardwareFlags == ((PrinterParam)object).hardwareFlags) break block47;
                return false;
            }
            return this.softwareFlags == ((PrinterParam)object).softwareFlags;
        }

        public PrinterParam clone() {
            try {
                return (PrinterParam)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }

    public static interface PrinterParamName
    extends IDzPrinter.PrintParamName {
        public static final String MOTOR_MODE = "MOTOR_MODE";
        public static final String AUTO_POWEROFF = "AUTO_POWEROFF";
        public static final String LANGUAGE = "LANGUAGE";
    }
}

