/*
 * Decompiled with CFR 0.152.
 */
package com.dothantech.printer;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.nfc.NdefRecord;
import android.os.Bundle;
import android.text.TextUtils;
import com.dothantech.b.a;
import com.dothantech.common.t;
import com.dothantech.common.w;
import com.dothantech.printer.DzPrinter;
import com.dothantech.printer.IDzPrinter2;
import com.dothantech.printer.n;
import com.dothantech.printer.o;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public interface IDzPrinter {
    public boolean init(Context var1, IDzPrinterCallback var2);

    public void quit();

    public boolean connect(PrinterAddress var1);

    public boolean connect(PrinterAddress var1, IActionCallback var2);

    public boolean connect(String var1);

    public boolean connect(String var1, IActionCallback var2);

    public boolean connectSync(PrinterAddress var1);

    public boolean connectSync(String var1);

    public void disconnect();

    public boolean reconnect();

    public boolean reconnect(IActionCallback var1);

    public boolean reconnectSync();

    public PrinterState getPrinterState();

    public PrinterInfo getPrinterInfo();

    public boolean waitPrinterState(PrinterState var1, long var2);

    public boolean print(Bitmap var1, Bundle var2);

    public boolean print(Bitmap var1, Bundle var2, IActionCallback var3);

    public boolean print(n var1, Bundle var2);

    public boolean print(n var1, Bundle var2, IActionCallback var3);

    public boolean print(o var1, Bundle var2);

    public boolean print(o var1, Bundle var2, IActionCallback var3);

    public boolean command(byte[] var1);

    public boolean command(byte[] var1, IActionCallback var2);

    public void cancel();

    public static enum AddressType {
        SPP,
        BLE,
        WiFi;

    }

    public static class Factory {
        public static IDzPrinter getInstance() {
            return DzPrinter.getInstance();
        }

        public static boolean isPrinterSupported(BluetoothDevice bluetoothDevice) {
            return a.b(bluetoothDevice) != a.b.a;
        }

        public static boolean isPrinterSupported(String string) {
            return a.d(string) != a.b.a;
        }

        public static PrinterAddress getFirstPrinter() {
            Set<BluetoothDevice> set = a.a();
            if (set != null && set.size() > 0 && (set = set.iterator()).hasNext()) {
                set = (BluetoothDevice)set.next();
                return new PrinterAddress(set.getName(), set.getAddress(), AddressType.SPP);
            }
            return null;
        }

        public static PrinterAddress getFirstPrinter(String object) {
            if ((object = w.c((String)object)) == null || ((ArrayList)object).size() <= 0) {
                return Factory.getFirstPrinter();
            }
            BluetoothDevice bluetoothDevice2 = a.a();
            if (bluetoothDevice2 != null && bluetoothDevice2.size() > 0) {
                for (BluetoothDevice bluetoothDevice2 : bluetoothDevice2) {
                    String string = a.c(bluetoothDevice2.getName());
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(bluetoothDevice2.getName())) continue;
                        return new PrinterAddress(bluetoothDevice2.getName(), bluetoothDevice2.getAddress(), AddressType.SPP);
                    }
                }
            }
            return null;
        }

        public static List<PrinterAddress> getAllPrinters() {
            return Factory.getAllPrinters(null);
        }

        public static List<PrinterAddress> getAllPrinters(String object) {
            object = w.c((String)object);
            BluetoothDevice bluetoothDevice2 = a.a();
            ArrayList<PrinterAddress> arrayList = new ArrayList<PrinterAddress>();
            if (bluetoothDevice2 == null) {
                return arrayList;
            }
            block0: for (BluetoothDevice bluetoothDevice2 : bluetoothDevice2) {
                if (object != null && object.size() > 0) {
                    String string = a.c(bluetoothDevice2.getName());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(bluetoothDevice2.getName())) continue;
                        arrayList.add(new PrinterAddress(bluetoothDevice2.getName(), bluetoothDevice2.getAddress(), AddressType.SPP));
                        continue block0;
                    }
                    continue;
                }
                arrayList.add(new PrinterAddress(bluetoothDevice2.getName(), bluetoothDevice2.getAddress(), AddressType.SPP));
            }
            return arrayList;
        }
    }

    public static enum GeneralProgress {
        Start,
        Success,
        Success2,
        Failed,
        Cancelled,
        Timeout,
        Info;

    }

    public static interface IActionCallback {
        public void onProgress(GeneralProgress var1, Object var2);
    }

    public static interface IActionWithResponseCallback
    extends IActionCallback {
        public void onResponse(byte[] var1);
    }

    public static interface IDzPrinterCallback {
        public void onProgressInfo(ProgressInfo var1, Object var2);

        public void onStateChange(PrinterAddress var1, PrinterState var2);

        public void onPrintProgress(PrinterAddress var1, Object var2, PrintProgress var3, Object var4);

        public void onPrinterDiscovery(PrinterAddress var1, PrinterInfo var2);
    }

    public static enum PrintFailReason {
        OK,
        IsPrinting,
        IsRotating,
        VolTooLow,
        VolTooHigh,
        TphNotFound,
        TphTooHot,
        TphTooCold,
        TphOpened,
        CoverOpened,
        No_Paper,
        No_Ribbon,
        Unmatched_Ribbon,
        Usedup_Ribbon,
        Usedup_Ribbon2,
        Cancelled,
        Timeout,
        Other;

    }

    public static interface PrintParamName {
        public static final String PRINT_DARKNESS = "PRINT_DENSITY";
        public static final String PRINT_DENSITY = "PRINT_DENSITY";
        public static final String PRINT_SPEED = "PRINT_SPEED";
        public static final String PRINT_DIRECTION = "PRINT_DIRECTION";
        public static final String PRINT_COPIES = "PRINT_COPIES";
        public static final String GAP_TYPE = "GAP_TYPE";
        public static final String GAP_LENGTH_01MM = "GAP_LENGTH_01MM";
        public static final String GAP_LENGTH_PX = "GAP_LENGTH_PX";
        public static final String GAP_LENGTH = "GAP_LENGTH_01MM";
        public static final String RIGHT_MARGIN_01MM = "RIGHT_MARGIN_01MM";
        public static final String RIGHT_MARGIN_PX = "RIGHT_MARGIN_PX";
        public static final String TOP_MARGIN_01MM = "TOP_MARGIN_01MM";
        public static final String TOP_MARGIN_PX = "TOP_MARGIN_PX";
        public static final String BOTTOM_MARGIN_01MM = "BOTTOM_MARGIN_01MM";
        public static final String BOTTOM_MARGIN_PX = "BOTTOM_MARGIN_PX";
        public static final String IMAGE_THRESHOLD = "IMAGE_THRESHOLD";
    }

    public static interface PrintParamValue {
        public static final int MIN_PRINT_DARKNESS = 0;
        public static final int DEFAULT_PRINT_DARKNESS = 5;
        public static final int MAX_PRINT_DARKNESS = 14;
        public static final int MIN_PRINT_SPEED = 0;
        public static final int DEFAULT_PRINT_SPEED = 2;
        public static final int MAX_PRINT_SPEED = 4;
        public static final int GAP_NONE = 0;
        public static final int GAP_HOLE = 1;
        public static final int GAP_GAP = 2;
        public static final int GAP_BLACK = 3;
    }

    public static enum PrintProgress {
        Connected,
        StartCopy,
        Success,
        Failed;

    }

    public static class PrinterAddress
    implements Cloneable {
        public final String macAddress;
        public final AddressType addressType;
        public final String shownName;

        public PrinterAddress(String string) {
            this(string, AddressType.SPP);
        }

        public PrinterAddress(String string, AddressType addressType) {
            this(null, string, addressType);
        }

        public PrinterAddress(String string, String string2, AddressType addressType) {
            this.macAddress = string2;
            this.addressType = addressType;
            this.shownName = string;
        }

        public boolean isValid() {
            return !TextUtils.isEmpty((CharSequence)this.macAddress);
        }

        public PrinterAddress clone() {
            try {
                return (PrinterAddress)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return "PrinterAddress [shownName=" + this.shownName + ", macAddress=" + this.macAddress + ", addressType=" + (Object)((Object)this.addressType) + "]";
        }

        public boolean equals(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            return string.equalsIgnoreCase(this.macAddress);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            try {
                if (object instanceof PrinterAddress) {
                    object = (PrinterAddress)object;
                    if (this.addressType == ((PrinterAddress)object).addressType) return this.equals(((PrinterAddress)object).macAddress);
                    return false;
                }
                if (!(object instanceof String)) return false;
                return this.equals((String)object);
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
            return false;
        }
    }

    public static class PrinterInfo
    implements Cloneable {
        public final int deviceType;
        public final String deviceName;
        public final String deviceAddress;
        public final int deviceAddrType;
        public final int deviceDPI;
        public final int deviceWidth;

        protected PrinterInfo(int n2, String string, String string2, int n3, int n4, int n5) {
            this.deviceType = n2;
            this.deviceName = string;
            this.deviceAddress = string2;
            this.deviceAddrType = n3;
            this.deviceDPI = n4;
            this.deviceWidth = n5;
        }

        public AddressType getAddressType() {
            return IDzPrinter2.DeviceAddrTypeConverter.type(this.deviceAddrType);
        }

        public PrinterAddress getPrinterAddress() {
            return new PrinterAddress(this.deviceName, this.deviceAddress, IDzPrinter2.DeviceAddrTypeConverter.type(this.deviceAddrType));
        }

        public static PrinterInfo valueOf(Intent objectArray) {
            NdefRecord ndefRecord;
            if (objectArray == null) {
                return null;
            }
            if ((objectArray = objectArray.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES")) == null || objectArray.length <= 0 || objectArray[0] == null) {
                return null;
            }
            objectArray = (NdefRecord[])objectArray[0];
            objectArray = objectArray.getRecords();
            byte[] byArray = objectArray[0].getPayload();
            objectArray = byArray;
            if (byArray == null || objectArray[0] != -86 || objectArray[objectArray.length - 1] != -69 || objectArray.length < 9 || ((ndefRecord = objectArray[1]) & 0xFF) != objectArray.length - 3) {
                return null;
            }
            if (objectArray.length < 49) {
                return null;
            }
            String string = w.a((byte[])objectArray, 24, 24);
            Object[] objectArray2 = new Object[6];
            ndefRecord = objectArray[7];
            objectArray2[0] = ndefRecord & 0xFF;
            ndefRecord = objectArray[6];
            objectArray2[1] = ndefRecord & 0xFF;
            ndefRecord = objectArray[5];
            objectArray2[2] = ndefRecord & 0xFF;
            ndefRecord = objectArray[4];
            objectArray2[3] = ndefRecord & 0xFF;
            ndefRecord = objectArray[3];
            objectArray2[4] = ndefRecord & 0xFF;
            ndefRecord = objectArray[2];
            objectArray2[5] = ndefRecord & 0xFF;
            String string2 = String.format("%02X:%02X:%02X:%02X:%02X:%02X", objectArray2);
            NdefRecord ndefRecord2 = objectArray[10];
            ndefRecord = ndefRecord2;
            ndefRecord = objectArray[15];
            return new PrinterInfo((int)(ndefRecord2 & 0xFF), string, string2, (int)(ndefRecord & 0xFF), t.a((byte)objectArray[11], (byte)objectArray[12]), t.a((byte)objectArray[13], (byte)objectArray[14]));
        }

        @SuppressLint(value={"DefaultLocale"})
        public String toString() {
            return "PrinterNfcInfo [deviceType=" + this.deviceType + ", deviceName=" + this.deviceName + ", deviceAddress=" + this.deviceAddress + ", deviceAddrType=" + this.deviceAddrType + ", deviceDPI=" + this.deviceDPI + ", deviceWidth=" + this.deviceWidth + "]";
        }

        public boolean equals(Object object) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (this == object) {
                                    return true;
                                }
                                if (object == null) {
                                    return false;
                                }
                                try {
                                    object = (PrinterInfo)object;
                                    if (this.deviceAddrType == ((PrinterInfo)object).deviceAddrType) break block9;
                                    return false;
                                }
                                catch (Exception exception) {
                                    object = exception;
                                    exception.printStackTrace();
                                    return false;
                                }
                            }
                            if (w.a(this.deviceName, ((PrinterInfo)object).deviceName)) break block10;
                            return false;
                        }
                        if (w.a(this.deviceAddress, ((PrinterInfo)object).deviceAddress)) break block11;
                        return false;
                    }
                    if (this.deviceDPI == ((PrinterInfo)object).deviceDPI) break block12;
                    return false;
                }
                if (this.deviceType == ((PrinterInfo)object).deviceType) break block13;
                return false;
            }
            return this.deviceWidth == ((PrinterInfo)object).deviceWidth;
        }

        public PrinterInfo clone() {
            try {
                return (PrinterInfo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }

    public static enum PrinterState {
        Connecting,
        Connected,
        Connected2,
        Printing,
        Working,
        Disconnected;

    }

    public static enum ProgressInfo {
        AdapterEnabling,
        AdapterEnabled,
        AdapterDisabled,
        DeviceBonding,
        DeviceBonded,
        DeviceUnbonded;

    }
}

